<?PHP
	$this->load->helper('form');
?>
					<script>
						$(function() {
							$("#tabs").tabs();
							$('[id^=details-modal]').dialog({ autoOpen: false })
							$('[id^=details-link]').click(function(e){
								e.preventDefault();
								var id = $(e.target).attr('id').replace('details-link','');
								$('[id^=details-modal]').dialog({
									modal:true,
									width:300,
									height:250
								});
								$('[id=details-modal'+id+']').dialog('open');
							});
						});
					</script>
					<?PHP 
						echo form_open('/administration/manage/accounts',array('id'=>'account_list_form'));
						$hidden_inputs = array(
							'page_select_correction' => '',
							'prefix' => '',
							'accounts_page_on_bar' => '',
							'accounts_page_select' => '',
							'accounts_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
							'deactivated_page_on_bar' => '',
							'deactivated_page_select' => '',
							'deactivated_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
						);
						echo form_hidden($hidden_inputs,TRUE);
						echo form_close();
					?>
					<div class="column">
						<?PHP if(isset($message)) { echo '<div class="message">'.$message.'</div>'; } ?>
						<?PHP if(isset($success_message)) { echo '<div class="message_success">'.$success_message.'</div>'; } ?>
						<?PHP if(isset($error_message)) { echo '<div class="message_error">'.$error_message.'</div>'; } ?>
						<div id="tabs" class="column">	
							<ul>
								<li><a id="accounts_link" href="#accounts">Accounts</a></li>
								<li><a id="deactivated_link" href="#deactivated">Disabled Accounts</a></li>
								<?PHP if($create_account_show) { ?><li><a href="#create">Create Account</a></li><?PHP } ?>
							</ul>
							
							<div id="accounts">
								<p>This table lists the active accounts on the system.</p>
								<?php if (sizeof($users) == 0) { ?>
									<div class="message">There are currently no active accounts.</div>
								<?php } else{ ?>
									<?PHP 
										echo form_open('/administration/manage/accounts',array('id'=>'account_list_form'));
										echo $accounts_pages->display_pagination_bar();
										echo form_close();
									?>
									<table class="display accounts">
										<tr>
											<th>Username</th>
											<th>ID</th>
											<th>Details</th>
											<th>Access</th>
											<th class="displaylast">Actions</th>
										</tr>
										<?PHP foreach($users as $user) { ?>
											<tr>
												<td class="center"><a href="/administration/manage/accounts/edit/<?PHP echo $user->user_id; ?>"><?PHP echo $user->username; ?></a></td>
												<td class="center"><?PHP echo $user->user_org_id; ?></td>
												<td class="center">
													<a href="#" id="details-link<?PHP echo $user->user_id; ?>">View Details</a>
													<div id="details-modal<?PHP echo $user->user_id; ?>" title="Account Details for <?PHP echo $user->username;?>">
														<table>
														<?PHP 
															echo '<tr><td>Name</td><td>'.$user->cn . '</td></tr>';
															if($user->title) { echo '<tr><td>Title</td><td>'.$user->title . '</td></tr>'; }
															if($user->departmentnumber) { echo '<tr><td>Department</td><td>'.$user->departmentnumber . '</td></tr>'; }
															if($user->o) { echo '<tr><td>Organization</td><td>'.$user->o . '</td></tr>'; }
															if($user->physicaldeliveryofficename) { echo '<tr><td>Location</td><td>'.$user->physicaldeliveryofficename . '</td></tr>'; }
															if($user->telephonenumber) { echo '<tr><td>Telephone</td><td>'.$user->telephonenumber . '</td></tr>'; }
															if($user->mobile) { echo '<tr><td>Mobile</td><td>'.$user->mobile . '</td></tr>'; }
															if($user->user_ext_mail) { echo '<tr><td>Email</td><td><a href="mailto:'.$user->user_ext_mail.'">'.$user->user_ext_mail.'</a></td></tr>'; }
														?>
														</table>
													</div>
												</td>
												<td><?PHP foreach($user->groups as $group) { echo $group . '<br/>'; } ?></td>
												<td class="center">
													<a href="/administration/manage/accounts/edit/<?PHP echo $user->user_id; ?>" title="Edit Account: <?PHP echo $user->username; ?>"><img src="/images/icons/user_edit.png" alt="Edit Account: <?PHP echo $user->username; ?>" /></a>
													<a href="/administration/manage/accounts/edit/access/<?PHP echo $user->user_id; ?>" title="Edit Access: <?PHP echo $user->username; ?>"><img src="/images/icons/group_edit.png" alt="Edit Access: <?PHP echo $user->username; ?>" /></a>
													<a onclick="if(confirm('Are you sure you want to disable <?PHP echo $user->username ?>?')) {$('#disable<?PHP echo $user->user_id; ?>').submit(); return false; }" href="#" title="Disable Account: <?PHP echo $user->username; ?>"><img src="/images/icons/delete.png" alt="Disable Account: <?PHP echo $user->username; ?>" /></a>
													<?PHP
														echo form_open('/administration/manage/accounts/disable',array('id'=>'disable'.$user->user_id));
														echo form_hidden('user_id', $user->user_id);
														$hidden_inputs = array(
															'accounts_page_select_from_disable_user_session' => $accounts_cur_page,
															'accounts_items_per_page_from_disable_user_session' => $accounts_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
															'deactivated_page_select_from_disable_user_session' => $deactivated_cur_page,
															'deactivated_items_per_page_from_disable_user_session' => $deactivated_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
														);
														echo form_close();
													?>
												</td>
											</tr>
										<?PHP } ?>
									</table>
									<?PHP
										echo form_open('/administration/manage/accounts',array('id'=>'account_list_form'));
										echo $accounts_pages->display_pagination_bar();
										echo form_close();
									?>
								<?php } ?>
							</div>
							<div id="deactivated">
								<p>This table lists the disabled accounts on the system.</p>
								<?php if (sizeof($disabled_users) == 0) { ?>
									<div class="message">There are currently no disabled accounts.</div>
								<?php } else{ ?>
									<?PHP
										echo form_open('/administration/manage/accounts',array('id'=>'account_list_form'));
										echo $deactivated_pages->display_pagination_bar();
										echo form_close();
									?>
									<table class="display accounts">
										<tr>
											<th>Username</th>
											<th>ID</th>
											<th>Details</th>
											<th>Access</th>
											<th class="displaylast">Actions</th>
										</tr>
										<?PHP foreach($disabled_users as $user) { ?>
											<tr>
												<td class="center"><a href="/administration/manage/accounts/edit/<?PHP echo $user->user_id; ?>"><?PHP echo $user->username; ?></a></td>
												<td class="center"><?PHP echo $user->user_org_id; ?></td>
												<td class="center">
													<a href="#" id="details-link<?PHP echo $user->user_id; ?>">View Details</a>
													<div id="details-modal<?PHP echo $user->user_id; ?>" title="Account Details for <?PHP echo $user->username;?>">
														<table>
														<?PHP 
															echo '<tr><td>Name</td><td>'.$user->cn . '</td></tr>';
															if($user->title) { echo '<tr><td>Title</td><td>'.$user->title . '</td></tr>'; }
															if($user->departmentnumber) { echo '<tr><td>Department</td><td>'.$user->departmentnumber . '</td></tr>'; }
															if($user->o) { echo '<tr><td>Organization</td><td>'.$user->o . '</td></tr>'; }
															if($user->physicaldeliveryofficename) { echo '<tr><td>Location</td><td>'.$user->physicaldeliveryofficename . '</td></tr>'; }
															if($user->telephonenumber) { echo '<tr><td>Telephone</td><td>'.$user->telephonenumber . '</td></tr>'; }
															if($user->mobile) { echo '<tr><td>Mobile</td><td>'.$user->mobile . '</td></tr>'; }
															if($user->user_ext_mail) { echo '<td>Email</td><td><a href="mailto:'.$user->user_ext_mail.'">'.$user->user_ext_mail.'</a></td></tr>'; }
														?>
														</table>
													</div>
												</td>
												<td><?PHP foreach($user->groups as $group) { echo $group . '<br/>'; } ?></td>
												<td class="center">
													<a href="/administration/manage/accounts/edit/<?PHP echo $user->user_id; ?>" title="Edit Account: <?PHP echo $user->username; ?>"><img src="/images/icons/user_edit.png" alt="Edit Account: <?PHP echo $user->username; ?>" /></a>
													<a href="/administration/manage/accounts/edit/access/<?PHP echo $user->user_id; ?>" title="Edit Access: <?PHP echo $user->username; ?>"><img src="/images/icons/group_edit.png" alt="Edit Access: <?PHP echo $user->username; ?>" /></a>
													<a onclick="if(confirm('Are you sure you want to enable <?PHP echo $user->username ?>?')) { $('#enable<?PHP echo $user->user_id; ?>').submit(); return false; }" href="#" title="Enable Account: <?PHP echo $user->username; ?>"><img src="/images/icons/add.png" alt="Enable Account: <?PHP echo $user->username; ?>" /></a>
													<?PHP 
														echo form_open('/administration/manage/accounts/enable',array('id'=>'enable'.$user->user_id));
														echo form_hidden('user_id',$user->user_id);
														$hidden_inputs = array(
															'deactivated_page_select_from_enable_user_session' => $deactivated_cur_page,
															'deactivated_items_per_page_from_enable_user_session' => $deactivated_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
															'accounts_page_select_from_enable_user_session' => $accounts_cur_page,
															'accounts_items_per_page_from_enable_user_session' => $accounts_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
														);
														echo form_hidden($hidden_inputs,TRUE);
														echo form_close();
													?>
												</td>
											</tr>
										<?PHP } ?>
									</table>
									<?PHP
										echo form_open('/administration/manage/accounts',array('id'=>'account_list_form'));
										echo $deactivated_pages->display_pagination_bar();
										echo form_close();
									?>
								<?php } ?>
							</div>
							<?PHP if($create_account_show) { ?>
								<div id ="create" class="column">		
									<p>This form allows an administrator to manually create a new user account.</p>
									<?PHP echo form_open('/administration/create_account','createAccountForm'); ?>
										<div class="form" style="width:100%;">
											<label for="user_name"><span class="red-text">*</span>Username:</label> <input type="text" name="user_name" id="user_name" <?PHP if(isset($user_name)) { echo 'value="'.$user_name.'"'; }?>/>
											<label for="user_org_id"><span class="red-text">*</span>ID:</label> <input type="text" name="user_org_id" id="user_org_id" <?PHP if(isset($user_org_id)) { echo 'value="'.$user_org_id.'"'; }?>/>
											<label for="first_name"><span class="red-text">*</span>First Name:</label> <input type="text" name="first_name" id="first_name" value="<?php if(isset($first_name)){echo $first_name;}?>"/>
											<label for="middle_name">Middle Name:</label> <input type="text" name="middle_name" id="middle_name" <?PHP if(isset($middle_name)) { echo 'value="'.$middle_name.'"'; }?>/>
											<label for="last_name"><span class="red-text">*</span>Last Name:</label> <input type="text" name="last_name" id="last_name" <?PHP if(isset($last_name)) { echo 'value="'.$last_name.'"'; }?>/>
											<label for="ext_mail"><span class="red-text">*</span>Email Address:</label> <input type="text" name="ext_mail" id="ext_mail" <?PHP if(isset($ext_mail)) { echo 'value="'.$ext_mail.'"'; }?>/>
											<label for="account_title">Title:</label> <input type="text" name="account_title" id="account_title" <?PHP if(isset($account_title)) { echo 'value="'.$account_title.'"'; }?>/>
											<label for="department">Department:</label> <input type="text" name="department" id="department" <?PHP if(isset($department)) { echo 'value="'.$department.'"'; }?>/>
											<label for="organization">Organization:</label> <input type="text" name="organization" id="organization" <?PHP if(isset($organization)) { echo 'value="'.$organization.'"'; }?>/>
											<label for="telephone">Telephone:</label> <input type="text" name="telephone" id="telephone" <?PHP if(isset($telephone)) { echo 'value="'.$telephone.'"'; }?>/>
											<label for="mobile">Mobile Phone:</label> <input type="text" name="mobile" id="mobile" <?PHP if(isset($mobile)) { echo 'value="'.$mobile.'"'; }?>/>
											<label for="location">Location:</label> <input type="text" name="location" id="location" <?PHP if(isset($location)) { echo 'value="'.$location.'"'; }?>/>
											<p class="red-text">
												* = Required Field
											</p>
										</div>
										<?PHP echo form_hidden('user_id',$user->user_id,'user_id'); ?>
										<div class="text-right" style="width:100%;"><input class="blue-button" type="submit" value="Submit"/></div> 
									<?PHP echo form_close(); ?>
								</div>								
							<?PHP } ?>
						</div>
					</div>
<script type='text/javascript'>
	goToSubTab(<?PHP if(isset($anchor)){echo json_encode($anchor);} ?>);
	assignPaginationFormValues(<?PHP echo json_encode($form_values); ?>);
</script>